import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Document, Schema as MongooseSchema } from 'mongoose';

export type UserDocument = User & Document;

@Schema({ timestamps: true })
export class User {
  @Prop({
    type: MongooseSchema.Types.ObjectId,
    ref: 'business',
    required: true,
  })
  businessId: MongooseSchema.Types.ObjectId;

  @Prop({ required: true, unique: true, lowercase: true })
  email: string;

  @Prop({ required: true })
  password: string;

  @Prop({ default: 'default.jpg' })
  photo: string;

  @Prop({ default: true })
  active: boolean;

  @Prop({ enum: ['admin', 'user', 'super'], default: 'user' })
  role: string;

  @Prop({ default: '' })
  token: string;
}

export const UserSchema = SchemaFactory.createForClass(User);
