import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Document, Schema as MongooseSchema } from 'mongoose';

export type UserLogsDocument = UserLogs & Document;

@Schema({ timestamps: true })
export class UserLogs {
  @Prop({
    type: MongooseSchema.Types.ObjectId,
    ref: 'business',
    required: true,
  })
  businessId: MongooseSchema.Types.ObjectId;

  @Prop({
    type: MongooseSchema.Types.ObjectId,
    ref: 'users',
    required: true,
  })
  userId: MongooseSchema.Types.ObjectId;

  @Prop({ default: '0.0.0.0' })
  ip: string;

  @Prop({ enum: ['login', 'logout'], default: 'login' })
  access: string;
}

export const UserLogsSchema = SchemaFactory.createForClass(UserLogs);
