import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Document, Schema as MongooseSchema } from 'mongoose';

@Schema({ timestamps: true })
export class Taxes {
  @Prop({
    type: MongooseSchema.Types.ObjectId,
    ref: 'business',
    required: true,
  })
  businessId: MongooseSchema.Types.ObjectId;

  @Prop({ default: 0 })
  tax_payment: number;

  @Prop({ default: 0 })
  tax_card: number;
}

export type TaxesDocument = Taxes & Document;
export const TaxesSchema = SchemaFactory.createForClass(Taxes);
