import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Document, Schema as MongooseSchema } from 'mongoose';
import { SaleItem, SaleItemSchema } from './sale-item.schema';

@Schema({ timestamps: true })
export class Sale {
  @Prop({
    type: MongooseSchema.Types.ObjectId,
    ref: 'business',
    required: true,
  })
  businessId: MongooseSchema.Types.ObjectId;

  @Prop({ required: true })
  userEmail: string;

  @Prop({ type: [SaleItemSchema], default: [] })
  products: SaleItem[];

  @Prop({ type: [SaleItemSchema], default: [] })
  products_with_prizes: SaleItem[];

  @Prop({ required: true })
  sub_total: number;

  @Prop({ required: true })
  prize: number; // premio ganado o para pagar

  @Prop({ default: 0 })
  remaining: number; // cantidad restante a completar pago

  @Prop({ default: '' })
  remaining_pay: string; //tipo de pago faltante en cash o card

  @Prop({ required: true })
  total: number;

  @Prop({ required: true })
  commission: number;

  @Prop({ required: true })
  payment: number; //pago de efectivo del premio, sale caja

  @Prop({ default: false })
  cancel?: boolean;

  @Prop({ default: 0 })
  cancel_amount?: number;

  @Prop({ default: 'cobro-efvo' })
  payment_type: string;

  @Prop({ default: 0 })
  partial_cash: number;

  @Prop({ default: 0 })
  partial_card: number;

  @Prop({ default: '' })
  turno_terminado: string;

  @Prop({
    type: MongooseSchema.Types.ObjectId,
    ref: 'cashcount',
    required: false,
  })
  cashcountId?: MongooseSchema.Types.ObjectId;
}

export type SaleDocument = Sale & Document;
export const SaleSchema = SchemaFactory.createForClass(Sale);
