import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Schema as MongooseSchema } from 'mongoose';

@Schema({ _id: false, timestamps: false })
export class SaleItem {
  @Prop({
    type: MongooseSchema.Types.ObjectId,
    ref: 'products',
    required: false,
  })
  productId?: MongooseSchema.Types.ObjectId;

  @Prop({ default: '' })
  prizeId: string;

  @Prop({ default: '' })
  categoria: string;

  @Prop({ default: '' })
  clave: string;

  @Prop({ default: '' })
  code_bar: string;

  @Prop({ default: true })
  exists: boolean;

  @Prop({ default: true })
  bet: boolean;

  @Prop({ default: new Date() })
  fecha: Date;

  @Prop({ default: '' })
  sorteo: string;

  @Prop({ default: 0 })
  cantidad: number;

  @Prop({ default: 0 })
  costo_venta: number;

  @Prop({ default: 0 })
  impuesto: number;
}

export const SaleItemSchema = SchemaFactory.createForClass(SaleItem);
