import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Schema as MongooseSchema } from 'mongoose';

@Schema({ timestamps: true }) // Importante
export class Saldos {
  @Prop({
    type: MongooseSchema.Types.ObjectId,
    ref: 'products',
    required: true,
  })
  productId: MongooseSchema.Types.ObjectId;

  @Prop({ default: '' })
  identificador: string;

  @Prop({ default: new Date() })
  fecha?: Date;

  @Prop({ default: '' })
  sorteo?: string;

  @Prop({ default: 0 })
  saldo_anterior: number;

  @Prop({ default: 0 })
  pago_anticipado: number;

  @Prop({ default: 0 })
  saldo_x_pagar: number;
}

export const SaldosSchema = SchemaFactory.createForClass(Saldos);
