import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Document, Schema as MongooseSchema } from 'mongoose';

@Schema({ timestamps: true })
export class GameType {
  @Prop({
    type: MongooseSchema.Types.ObjectId,
    ref: 'business',
    required: true,
  })
  businessId: MongooseSchema.Types.ObjectId;

  @Prop({ required: true })
  categoria: string;

  @Prop({ required: true })
  clave: string;
}

export type GameTypeDocument = GameType & Document;
export const GameTypeSchema = SchemaFactory.createForClass(GameType);
