// finanzas.schema.ts
import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { ValesSchema } from './vales.schema';
import { Document, Schema as MongooseSchema } from 'mongoose';

export type FinanzasDocument = Finanzas & Document;

@Schema({ timestamps: true }) // 👈 crea createdAt y updatedAt automáticos
export class Finanzas {
  @Prop({
    type: MongooseSchema.Types.ObjectId,
    ref: 'business',
    required: true,
  })
  businessId: MongooseSchema.Types.ObjectId;

  @Prop({ type: [ValesSchema], default: [] })
  gastos: any[];

  @Prop({ type: Number, default: 0 })
  total_gastos: number;

  @Prop({ type: [ValesSchema], default: [] })
  proveedores: any[];

  @Prop({ type: Number, default: 0 })
  total_proveedores: number;

  @Prop({ type: [ValesSchema], default: [] })
  egresos: any[];

  @Prop({ type: Number, default: 0 })
  total_egresos: number;

  @Prop({ type: [ValesSchema], default: [] })
  ingresos: any[];

  @Prop({ type: Number, default: 0 })
  total_ingresos: number;

  @Prop({
    type: {
      total_comision: { type: Number, default: 0 },
      otros_ingresos: { type: Number, default: 0 },
      egresos: { type: Number, default: 0 },
      otros_egresos: { type: Number, default: 0 },
    },
    _id: false,
  })
  entradas_salidas: {
    total_comision: number;
    otros_ingresos: number;
    egresos: number;
    otros_egresos: number;
  };

  @Prop({
    type: {
      saldo_anterior: { type: Number, default: 0 },
      ingresos: { type: Number, default: 0 },
      egresos: { type: Number, default: 0 },
      saldo_actual: { type: Number, default: 0 },
    },
    _id: false,
  })
  flujo_efectivo: {
    saldo_anterior: number;
    ingresos: number;
    egresos: number;
    saldo_actual: number;
  };

  @Prop({
    type: {
      total_comision: { type: Number, default: 0 },
      total_salidas: { type: Number, default: 0 },
    },
    _id: false,
  })
  punto_equilibrio: {
    total_comision: number;
    total_salidas: number;
  };

  @Prop({ type: Number, default: 0 })
  total_comision: number;
}

export const FinanzasSchema = SchemaFactory.createForClass(Finanzas);
