import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Schema as MongooseSchema } from 'mongoose';

@Schema({ timestamps: true }) // Importante
export class Devoluciones {
  @Prop({
    type: MongooseSchema.Types.ObjectId,
    ref: 'products',
    required: true,
  })
  productId: MongooseSchema.Types.ObjectId;

  @Prop({ default: '' })
  identificador: string;

  @Prop({ default: new Date() })
  fecha?: Date;

  @Prop({ default: '' })
  sorteo?: string;

  @Prop({ default: 0 })
  dotacion: number;

  @Prop({ default: 0 })
  devolucion: number;
}

export const DevolucionesSchema = SchemaFactory.createForClass(Devoluciones);
