import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Document, Schema as MongooseSchema } from 'mongoose';

// ---------- SUBSCHEMA: ComisionProducts ----------
@Schema({ _id: false, timestamps: false })
export class ComisionProducts {
  @Prop({ required: true })
  cantidad: number;

  @Prop({ required: true })
  comision: number;

  @Prop({ required: true })
  commission: number;

  @Prop({ required: true })
  costo_venta: number;

  @Prop({ required: true })
  productId: string;

  @Prop({ required: true })
  identificador: string;

  @Prop({ required: true })
  categoria: string;

  @Prop({ required: true })
  clave: string;

  @Prop()
  sorteo: string;

  @Prop()
  fecha: string; // fecha del sorteo
}

export const ComisionProductsSchema =
  SchemaFactory.createForClass(ComisionProducts);

// ---------- SUBSCHEMA: ComisionVenta ----------
@Schema({ _id: false, timestamps: false })
export class ComisionVenta {
  @Prop({ required: true })
  commissionTotal: number;

  @Prop({ type: [ComisionProductsSchema], default: [] })
  products: ComisionProducts[];

  @Prop({ required: true })
  totalSale: number;

  @Prop({ required: true })
  createdAt: string;

  @Prop({ required: true })
  payment_type: string;

  @Prop({ required: true })
  ventaId: string;
}

// ---------- MAIN SCHEMA: ComisionesTurnos ----------

export const ComisionVentaSchema = SchemaFactory.createForClass(ComisionVenta);

@Schema({ timestamps: true })
export class Comision {
  @Prop({
    type: MongooseSchema.Types.ObjectId,
    ref: 'cashcount',
    required: true,
  })
  cashcountId: MongooseSchema.Types.ObjectId;

  @Prop({
    type: MongooseSchema.Types.ObjectId,
    ref: 'business',
    required: true,
  })
  businessId: MongooseSchema.Types.ObjectId;

  @Prop({ required: true })
  turno: string;

  @Prop({ required: true })
  commissionTotalTurno: number;

  @Prop({ type: [ComisionVentaSchema], default: [] })
  ventas: ComisionVenta[];
}

export type ComisionDocument = Comision & Document;
export const ComisionSchema = SchemaFactory.createForClass(Comision);
