import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Document, Schema as MongooseSchema } from 'mongoose';

@Schema({ timestamps: true })
export class BoxCash {
  @Prop({
    type: MongooseSchema.Types.ObjectId,
    ref: 'business',
    required: true,
  })
  businessId: MongooseSchema.Types.ObjectId;

  @Prop({ type: MongooseSchema.Types.ObjectId, ref: 'users', required: true })
  userId: MongooseSchema.Types.ObjectId;

  @Prop({ default: 0 })
  caja_chica: number;
}

export type BoxCashDocument = BoxCash & Document;
export const BoxCashSchema = SchemaFactory.createForClass(BoxCash);
