import { TaxesService } from './taxes.service';
import { TaxesController } from './taxes.controller';
import { Module } from '@nestjs/common';
import { JwtModule } from '@nestjs/jwt';
import { MongooseModule } from '@nestjs/mongoose';
import { UserSchema } from '@schemas/user.schema';
import { JwtStrategy } from '@common/jwt/jwt.strategy';
import { TaxesSchema } from '@schemas/taxes.schema';

@Module({
  imports: [
    MongooseModule.forFeature([
      { name: 'users', schema: UserSchema },
      { name: 'taxes', schema: TaxesSchema },
    ]),
    JwtModule.registerAsync({
      useFactory: () => ({
        secret: process.env.JWT_SECRET,
        signOptions: { expiresIn: process.env.JWT_EXPIRES_IN },
      }),
    }),
  ],
  controllers: [TaxesController],
  providers: [TaxesService, JwtStrategy],
})
export class TaxesModule {}
