/* eslint-disable @typescript-eslint/no-unsafe-argument */
import { Body, Controller, Get, Put, UseGuards } from '@nestjs/common';
import { AuthGuard } from '@nestjs/passport';
import { ApiBearerAuth } from '@nestjs/swagger';
import { TaxesService } from './taxes.service';
import { Profile } from '@common/guards/profile.decorator';
import { JWToken } from '@dtos/general.interface';

@ApiBearerAuth()
@Controller('tax')
@UseGuards(AuthGuard('jwt'))
export class TaxesController {
  constructor(private readonly taxService: TaxesService) {}

  @Get()
  findAll(@Profile() user: JWToken) {
    return this.taxService.findAll(user.userId);
  }

  @Put()
  update(@Body() body: any, @Profile() user: JWToken) {
    return this.taxService.update(body, user.userId);
  }
}
