/* eslint-disable @typescript-eslint/no-unsafe-argument */
import {
  Body,
  Controller,
  Delete,
  Get,
  Param,
  Post,
  Put,
  Query,
  UseGuards,
} from '@nestjs/common';
import { AuthGuard } from '@nestjs/passport';
import { ApiBearerAuth } from '@nestjs/swagger';
import { ShoppingsService } from './shoppings.service';
import { Profile } from '@common/guards/profile.decorator';
import { JWToken } from '@dtos/general.interface';

@ApiBearerAuth()
@Controller('shoppings')
@UseGuards(AuthGuard('jwt'))
export class ShoppingsController {
  constructor(private readonly shoppingService: ShoppingsService) {}

  @Post()
  create(@Body() dto: any) {
    return this.shoppingService.create(dto);
  }

  @Get('finanzas')
  findFinanzas(
    @Profile() user: JWToken,
    @Query('start') start: string,
    @Query('end') end: string,
  ) {
    return this.shoppingService.findFinanzas(
      user.userId,
      start !== '' ? start : null,
      end !== '' ? end : null,
    );
  }

  @Get('all-full')
  findAllFull(
    @Profile() user: JWToken,
    @Query('start') start: string,
    @Query('end') end: string,
  ) {
    return this.shoppingService.findAllFull(
      user.userId,
      start !== '' ? start : null,
      end !== '' ? end : null,
    );
  }

  @Get()
  findAll(
    @Profile() user: JWToken,
    @Query('start') start: string,
    @Query('end') end: string,
  ) {
    return this.shoppingService.findAll(
      user.userId,
      start !== '' ? start : null,
      end !== '' ? end : null,
    );
  }

  @Get(':id')
  findOne(@Param('id') id: string) {
    return this.shoppingService.findOne(id);
  }

  @Put('create-finanzas/:id')
  updateFinanzas(
    @Param('id') id: string,
    @Body() dto: any,
    @Profile() user: JWToken,
  ) {
    return this.shoppingService.updateFinanzas(id, dto, user.userId);
  }

  @Put(':id')
  update(@Param('id') id: string, @Body() dto: any) {
    return this.shoppingService.update(id, dto);
  }

  @Delete('all')
  removeAll(@Profile() user: JWToken) {
    return this.shoppingService.removeAll(user.userId);
  }

  @Delete(':id')
  remove(@Param('id') id: string) {
    return this.shoppingService.remove(id);
  }
}
