import { NotificationsService } from './notifications.service';
import { NotificationsController } from './notifications.controller';
import { Module } from '@nestjs/common';
import { MongooseModule } from '@nestjs/mongoose';
import { UserSchema } from '@schemas/user.schema';
import { JwtModule } from '@nestjs/jwt';
import { JwtStrategy } from '@common/jwt/jwt.strategy';
import { MultimediaService } from '@services/multimedia.service';
import { NotificationSchema } from '@schemas/notification.schema';

@Module({
  imports: [
    MongooseModule.forFeature([
      { name: 'users', schema: UserSchema },
      { name: 'notifications', schema: NotificationSchema },
    ]),
    JwtModule.registerAsync({
      useFactory: () => ({
        secret: process.env.JWT_SECRET,
        signOptions: { expiresIn: process.env.JWT_EXPIRES_IN },
      }),
    }),
  ],
  controllers: [NotificationsController],
  providers: [NotificationsService, JwtStrategy, MultimediaService],
  exports: [NotificationsService],
})
export class NotificationsModule {}
