/* eslint-disable @typescript-eslint/no-unsafe-argument */
import {
  Body,
  Controller,
  Delete,
  Get,
  Param,
  Post,
  UseGuards,
} from '@nestjs/common';
import { AuthGuard } from '@nestjs/passport';
import { ApiBearerAuth } from '@nestjs/swagger';
import { NotificationsService } from './notifications.service';
import { Profile } from '@common/guards/profile.decorator';
import { JWToken } from '@dtos/general.interface';

@ApiBearerAuth()
@Controller('notifications')
@UseGuards(AuthGuard('jwt'))
export class NotificationsController {
  constructor(private readonly notifyService: NotificationsService) {}

  @Post()
  async create(@Body() data: any) {
    return this.notifyService.create(data);
  }

  @Get()
  async getAll(@Profile() user: JWToken) {
    return this.notifyService.getAll(user.userId);
  }

  @Delete(':id')
  remove(@Param('id') id: string) {
    return this.notifyService.remove(id);
  }
}
