/* eslint-disable @typescript-eslint/no-unsafe-return */
import { Profile } from '@common/guards/profile.decorator';
import { JWToken } from '@dtos/general.interface';
import {
  Body,
  Controller,
  Get,
  Post,
  Put,
  Query,
  UseGuards,
} from '@nestjs/common';
import { AuthGuard } from '@nestjs/passport';
import { ApiBearerAuth } from '@nestjs/swagger';
import { MetricsService } from './metrics.service';

@ApiBearerAuth()
@Controller('metrics')
@UseGuards(AuthGuard('jwt'))
export class MetricsController {
  constructor(private readonly metricsService: MetricsService) {}

  @Post()
  create(@Body() createSaleDto: any) {
    return createSaleDto;
  }

  @Put('small-box')
  async setSmallBox(
    @Profile() user: JWToken,
    @Body() caja: { _id: string; caja_chica: number },
  ) {
    return await this.metricsService.setSmallBox(caja, user.userId);
  }

  @Get('small-box')
  async getSmallBox(@Profile() user: JWToken) {
    return await this.metricsService.getSmallBox(user.userId);
  }

  // Productos disponibles y tangibles para punto
  @Get('daily')
  findDailySales(
    @Profile() user: JWToken,
    @Query('start') start: string,
    @Query('end') end: string,
  ) {
    return this.metricsService.findDailySalesTest(
      user.userId,
      start !== '' ? start : null,
      end !== '' ? end : null,
    );
  }

  @Get('daily-full')
  findDailyFull(
    @Profile() user: JWToken,
    @Query('start') start: string,
    @Query('end') end: string,
    @Query('turno') turno: string,
  ) {
    return this.metricsService.findDailyFull(user.userId, start, end, turno);
  }

  @Get('daily-corte')
  findDailyCorteCaja(
    @Profile() user: JWToken,
    @Query('start') start: string,
    @Query('end') end: string,
  ) {
    return this.metricsService.findDailyCorteCaja(user.userId, start, end);
  }

  @Get('daily-comision')
  findDailyComision(
    @Profile() user: JWToken,
    @Query('start') start: string,
    @Query('end') end: string,
  ) {
    return this.metricsService.findDailyComision(user.userId, start, end);
  }

  @Get('monthly-comision')
  findMonthlyComision(
    @Profile() user: JWToken,
    @Query('start') start: string,
    @Query('end') end: string,
  ) {
    return this.metricsService.findMonthlyComision(user.userId, start, end);
  }

  @Get('monthly-balance')
  findMonthlyBalance(
    @Profile() user: JWToken,
    @Query('start') start: string,
    @Query('end') end: string,
  ) {
    return this.metricsService.findMonthlyBalance(user.userId, start, end);
  }

  @Get('daily-products')
  findDailyProductsSales(
    @Profile() user: JWToken,
    @Query('start') start: string,
    @Query('end') end: string,
  ) {
    return this.metricsService.findDailyProductsSales(
      user.userId,
      start !== '' ? start : null,
      end !== '' ? end : null,
    );
  }

  @Get('weekly')
  findWeeklySales(@Profile() user: JWToken, @Query('start') start: string) {
    return this.metricsService.findWeeklySales(
      user.userId,
      start !== '' ? start : null,
    );
  }
}
