import { Profile } from '@common/guards/profile.decorator';
import { JWToken } from '@dtos/general.interface';
import { Controller, Get, Query, UseGuards } from '@nestjs/common';
import { AuthGuard } from '@nestjs/passport';
import { ApiBearerAuth } from '@nestjs/swagger';
import { InventoryService } from './inventory.service';

@ApiBearerAuth()
@Controller('inventory')
@UseGuards(AuthGuard('jwt'))
export class InventoryController {
  constructor(private readonly inventoryService: InventoryService) {}

  @Get('entradas')
  findAllEntradas(
    @Profile() user: JWToken,
    @Query('start') start: string,
    @Query('end') end: string,
  ) {
    return this.inventoryService.findAllDetailsEntradas(
      user.userId,
      start !== '' ? start : null,
      end !== '' ? end : null,
    );
  }

  @Get('salidas')
  findAllSalidas(
    @Profile() user: JWToken,
    @Query('start') start: string,
    @Query('end') end: string,
  ) {
    return this.inventoryService.findAllDetailsSalidas(
      user.userId,
      start !== '' ? start : null,
      end !== '' ? end : null,
    );
  }
}
