/*
https://docs.nestjs.com/modules
*/

import { Module } from '@nestjs/common';
import { GameTypesController } from './gametypes.controller';
import { GameTypesService } from './gametypes.service';
import { JwtStrategy } from '@common/jwt/jwt.strategy';
import { JwtModule } from '@nestjs/jwt';
import { MongooseModule } from '@nestjs/mongoose';
import { BusinessSchema } from '@schemas/business.schema';
import { GameTypeSchema } from '@schemas/game-type.schema';
import { ProductSchema } from '@schemas/product.schema';
import { UserSchema } from '@schemas/user.schema';

@Module({
  imports: [
    MongooseModule.forFeature([
      { name: 'users', schema: UserSchema },
      { name: 'business', schema: BusinessSchema },
      { name: 'products', schema: ProductSchema },
      { name: 'gametypes', schema: GameTypeSchema },
    ]),
    JwtModule.registerAsync({
      useFactory: () => ({
        secret: process.env.JWT_SECRET,
        signOptions: { expiresIn: process.env.JWT_EXPIRES_IN },
      }),
    }),
  ],
  controllers: [GameTypesController],
  providers: [GameTypesService, JwtStrategy],
})
export class GameTypesModule {}
