import { Module } from '@nestjs/common';
import { JwtModule } from '@nestjs/jwt';
import { MongooseModule } from '@nestjs/mongoose';
import { BusinessSchema } from '@schemas/business.schema';
import { UserSchema } from '@schemas/user.schema';
import { CashCountController } from './cashcount.controller';
import { CashCountService } from './cashcount.service';
import { JwtStrategy } from '@common/jwt/jwt.strategy';
import { CashCountSchema } from '@schemas/cash-count.schema';
import { SaleSchema } from '@schemas/sale.schema';
import { ComisionSchema } from '@schemas/comision.schema';

@Module({
  imports: [
    MongooseModule.forFeature([
      { name: 'users', schema: UserSchema },
      { name: 'business', schema: BusinessSchema },
      { name: 'cashcount', schema: CashCountSchema },
      { name: 'comision', schema: ComisionSchema },
      { name: 'sales', schema: SaleSchema },
    ]),
    JwtModule.registerAsync({
      useFactory: () => ({
        secret: process.env.JWT_SECRET,
        signOptions: { expiresIn: process.env.JWT_EXPIRES_IN },
      }),
    }),
  ],
  controllers: [CashCountController],
  providers: [CashCountService, JwtStrategy],
})
export class CashCountModule {}
