/* eslint-disable @typescript-eslint/no-unsafe-argument */
import {
  Body,
  Controller,
  Delete,
  Get,
  Param,
  Post,
  Put,
  Query,
  UseGuards,
} from '@nestjs/common';
import { CashCountService } from './cashcount.service';
import { ApiBearerAuth } from '@nestjs/swagger';
import { AuthGuard } from '@nestjs/passport';
import { Profile } from '@common/guards/profile.decorator';
import { JWToken } from '@dtos/general.interface';

@ApiBearerAuth()
@Controller('cash-count')
@UseGuards(AuthGuard('jwt'))
export class CashCountController {
  constructor(private readonly corteCajaService: CashCountService) {}

  @Post()
  create(@Body() dto: any, @Profile() user: JWToken) {
    return this.corteCajaService.create(dto, user.userId);
  }

  @Get()
  findAll(
    @Profile() user: JWToken,
    @Query('start') start: string,
    @Query('end') end: string,
  ) {
    return this.corteCajaService.findAll(user.userId, start, end);
  }

  @Get(':id')
  findOne(@Param('id') id: string) {
    return this.corteCajaService.findOne(id);
  }

  @Put(':id')
  update(@Param('id') id: string, @Body() dto: any) {
    return this.corteCajaService.update(id, dto);
  }

  @Delete(':id')
  remove(@Param('id') id: string) {
    return this.corteCajaService.remove(id);
  }
}
