/* eslint-disable @typescript-eslint/no-unsafe-return */
import {
  Body,
  Controller,
  Post,
  Req,
  UploadedFile,
  UseInterceptors,
} from '@nestjs/common';
import { AuthService } from './auth.service';
import { FileInterceptor } from '@nestjs/platform-express';
import { CreateUserDto, LoginDto } from '@dtos/create-user.dto';
import { Request } from 'express';

@Controller('auth')
export class AuthController {
  constructor(private readonly authService: AuthService) {}

  @Post('register')
  @UseInterceptors(FileInterceptor('photo'))
  async register(
    @UploadedFile() file: Express.Multer.File,
    @Body() createUserDto: CreateUserDto,
  ) {
    return this.authService.register(file, createUserDto);
  }

  @Post('login')
  async login(@Body() createUserDto: LoginDto, @Req() req: Request) {
    return await this.authService.login(createUserDto, req);
  }

  @Post('recovery')
  async recoveryStep1(@Body() recoverUserDto: any) {
    return await this.authService.recoveryStep1(recoverUserDto);
  }

  @Post('confirm-recovery')
  async recoveryStep2(@Body() recoverUserDto: any) {
    return this.authService.recoveryStep2(recoverUserDto);
  }
}
