/* eslint-disable @typescript-eslint/no-floating-promises */
import { NestFactory } from '@nestjs/core';
import { AppModule } from './app.module';
import { NestExpressApplication } from '@nestjs/platform-express';
import 'dotenv/config';
import { ValidationPipe } from '@nestjs/common';
import { SwaggerModule, DocumentBuilder } from '@nestjs/swagger';
import { AllExceptionsFilter } from '@common/filters/all-exceptions.filter';
import { join } from 'path';
//import * as fs from 'fs';

async function bootstrap() {
  // Cargar los archivos SSL
  /*const httpsOptions = {
    key: fs.readFileSync(join(__dirname, '..', 'ssl', 'ssl.key')),
    cert: fs.readFileSync(join(__dirname, '..', 'ssl', 'ssl.cert')),
  };*/

  const app = await NestFactory.create<NestExpressApplication>(AppModule);

  app.enableCors();
  app.useStaticAssets(join(__dirname, '..', 'media'), { prefix: '/app' });
  app.useGlobalFilters(new AllExceptionsFilter());
  app.useGlobalPipes(new ValidationPipe());

  const config = new DocumentBuilder()
    .setTitle('Sever Crtl Click')
    .setDescription('Backend Crtl Click')
    .setVersion('0.0.1')
    .addTag('ctrlclick')
    .addBearerAuth()
    .build();
  const documentFactory = () => SwaggerModule.createDocument(app, config);
  SwaggerModule.setup('docs', app, documentFactory);

  // Escucha en tu IP privada y puerto 3002
  await app.listen(3002);
}
bootstrap();
