import { IsString, IsOptional, IsBoolean, IsEnum } from 'class-validator';
import { Types } from 'mongoose';

export class LoginDto {
  @IsString()
  email: string;

  @IsString()
  password: string;
}

export class CreateUserDto {
  @IsString()
  email: string;

  @IsString()
  password: string;

  @IsOptional()
  @IsString()
  photo?: string;

  @IsOptional()
  @IsBoolean()
  active?: boolean;

  @IsEnum(['admin', 'user', 'super'])
  role?: 'admin' | 'user' | 'super';
}

export class UpdateUserDto extends CreateUserDto {
  @IsString()
  _id: Types.ObjectId;

  @IsString()
  businessId: Types.ObjectId;
}
