import {
  IsEmail,
  IsNotEmpty,
  IsNumber,
  IsArray,
  ValidateNested,
  IsString,
  IsBoolean,
  IsOptional,
} from 'class-validator';
import { Type } from 'class-transformer';
import { PartialType } from '@nestjs/swagger';

export class CreateItemDto {
  @IsOptional()
  @IsString()
  productId?: string;

  @IsOptional()
  @IsString()
  prizeId?: string;

  @IsString()
  categoria: string;

  @IsString()
  clave: string;

  @IsString()
  code_bar: string;

  @IsBoolean()
  exists: boolean;

  @IsBoolean()
  bet: boolean;

  @IsString()
  fecha: string;

  @IsString()
  sorteo: string;

  @IsNumber()
  cantidad: number;

  @IsNumber()
  costo_venta: number;

  @IsNumber()
  impuesto: number;
}

export class CreateSaleDto {
  @IsNotEmpty()
  businessId: string;

  @IsEmail()
  userEmail: string;

  @IsArray()
  @ValidateNested({ each: true })
  @Type(() => CreateItemDto)
  products: CreateItemDto[];

  @IsArray()
  @ValidateNested({ each: true })
  @Type(() => CreateItemDto)
  products_with_prizes: CreateItemDto[];

  @IsNumber()
  sub_total: number;

  @IsNumber()
  prize: number;

  @IsNumber()
  remaining: number;

  @IsString()
  remaining_pay: string;

  @IsNumber()
  total: number;

  @IsNumber()
  commission: number;

  @IsNumber()
  payment: number;

  @IsString()
  payment_type: string;

  @IsNumber()
  partial_cash: number;

  @IsNumber()
  partial_card: number;
}

export class UpdateSaleDto extends PartialType(CreateSaleDto) {
  @IsNotEmpty()
  _id: string;
}
