import { IsNotEmpty, IsOptional, IsString, IsMongoId } from 'class-validator';

export class CreateNotificationDto {
  @IsMongoId()
  @IsNotEmpty()
  userId: string;

  @IsString()
  @IsNotEmpty()
  title: string;

  @IsString()
  @IsNotEmpty()
  body: string;

  @IsOptional()
  @IsString()
  image?: string;

  @IsOptional()
  data: any;
}
