import { WEBSITE } from '@common/constants/game-types.constant';
import { Controller, Get, Res } from '@nestjs/common';
import { Response } from 'express';
import { AppService } from './app.service';

@Controller()
export class AppController {
  constructor(private readonly appService: AppService) {}

  @Get('online')
  getOnline(): string {
    return this.appService.getHello();
  }

  @Get()
  getHello(@Res() res: Response) {
    return res.redirect(WEBSITE);
  }
}
